<?php

declare(strict_types=1);

namespace Erlage\Photogram;

use Erlage\Photogram\Constants\SystemConstants;

final class State
{
    /**
     * @var bool
     */
    private static $dispatched = false;

    /**
     * @var string
     */
    private static $method = SystemConstants::NA;

    /**
     * @var string
     */
    private static $reqType = SystemConstants::NA;

    /**
     * @var string
     */
    private static $apiVersion = SystemConstants::NA;

    public static function isDispatched(): bool
    {
        return self::$dispatched;
    }

    public static function getMethod(): string
    {
        return self::$method;
    }

    public static function getReqType(): string
    {
        return self::$reqType;
    }

    public static function getApiVersion(): string
    {
        return self::$apiVersion;
    }

    public static function setDispatched(bool $dispatched): bool
    {
        return self::$dispatched = $dispatched;
    }

    public static function setMethod(string $method): string
    {
        return self::$method = $method;
    }

    public static function setReqType(string $reqType): string
    {
        return self::$reqType = $reqType;
    }

    public static function setApiVersion(string $apiVersion): string
    {
        return self::$apiVersion = $apiVersion;
    }
}
